/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.AxisEvent;
import ibm.nways.jdm.AxisListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Vector;

class AxisCanvas
extends Container
implements MouseListener,
MouseMotionListener,
ActionListener {
    public static final int NO_ORIENTATION = 0;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    AxisBar bar;
    Vector listeners;
    ImgButton button1;
    ImgButton button2;
    Component backCanvas;
    int orientation = 0;
    Color color = Color.lightGray;

    public AxisCanvas(Color color) {
        this(color, 0);
    }

    public AxisCanvas(Color color, int n) {
        this.color = color;
        this.setLayout(new AxisLayout());
        this.bar = new AxisBar(this.color);
        this.bar.addMouseListener(this);
        this.bar.addMouseMotionListener(this);
        this.add((Component)this.bar, "AxisBar");
        this.setOrientation(n);
    }

    public int getMinimumWidth() {
        AxisLayout axisLayout = (AxisLayout)this.getLayout();
        return axisLayout.getMinimumWidth();
    }

    public int getMinimumHeight() {
        AxisLayout axisLayout = (AxisLayout)this.getLayout();
        return axisLayout.getMinimumHeight();
    }

    public void setOrientation(int n) {
        if (this.orientation == n) {
            return;
        }
        if (this.button1 != null) {
            this.remove(this.button1);
        }
        if (this.button2 != null) {
            this.remove(this.button2);
        }
        if (this.backCanvas != null) {
            this.remove(this.backCanvas);
        }
        this.orientation = n;
        if (n == 1) {
            this.bar.setCursor(Cursor.getPredefinedCursor(10));
            this.button1 = new LeftButton(this.color);
            this.button1.setActionCommand("LeftButton");
            this.button1.addActionListener(this);
            this.add((Component)this.button1, "B1");
            this.button2 = new RightButton(this.color);
            this.button2.setActionCommand("RightButton");
            this.button2.addActionListener(this);
            this.add((Component)this.button2, "B2");
            this.backCanvas = new BackCanvas(this.color);
            this.add(this.backCanvas, "BackCanvas");
            return;
        }
        if (n == 2) {
            this.bar.setCursor(Cursor.getPredefinedCursor(8));
            this.button1 = new UpButton(this.color);
            this.button1.setActionCommand("UpButton");
            this.button1.addActionListener(this);
            this.add((Component)this.button1, "B1");
            this.button2 = new DownButton(this.color);
            this.button2.setActionCommand("DownButton");
            this.button2.addActionListener(this);
            this.add((Component)this.button2, "B2");
            this.backCanvas = new BackCanvas(this.color);
            this.add(this.backCanvas, "BackCanvas");
        }
    }

    public void addAxisListener(AxisListener axisListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(axisListener);
    }

    public void removeAxisListener(AxisListener axisListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(axisListener);
        }
    }

    public void notifyListeners(AxisEvent axisEvent) {
        if (this.listeners != null) {
            int n = 0;
            while (n < this.listeners.size()) {
                AxisListener axisListener = (AxisListener)this.listeners.elementAt(n);
                switch (axisEvent.getId()) {
                    case 1: {
                        axisListener.axisShiftNegative(axisEvent);
                        break;
                    }
                    case 2: {
                        axisListener.axisShiftPositive(axisEvent);
                        break;
                    }
                    case 3: {
                        axisListener.axisDragged(axisEvent);
                        break;
                    }
                    case 4: {
                        axisListener.axisDropped(axisEvent);
                        break;
                    }
                }
                ++n;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this.bar) {
            AxisEvent axisEvent = new AxisEvent(this, 4, mouseEvent.getX(), mouseEvent.getY());
            this.notifyListeners(axisEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this.bar) {
            AxisEvent axisEvent = new AxisEvent(this, 3, mouseEvent.getX(), mouseEvent.getY());
            this.notifyListeners(axisEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("LeftButton") || string.equals("UpButton")) {
            AxisEvent axisEvent = new AxisEvent(this, 1);
            this.notifyListeners(axisEvent);
            return;
        }
        if (string.equals("RightButton") || string.equals("DownButton")) {
            AxisEvent axisEvent = new AxisEvent(this, 2);
            this.notifyListeners(axisEvent);
        }
    }

    class AxisBar
    extends Component {
        int barWidth = 5;
        int barHeight = 5;
        private Color color;

        public AxisBar(Color color) {
            AxisCanvas.this = AxisCanvas.this;
            this.color = color;
        }

        public void paint(Graphics graphics) {
            this.getBounds();
            int n = 0;
            int n2 = this.getSize().width;
            int n3 = 0;
            int n4 = this.getSize().height;
            graphics.setColor(this.color);
            graphics.draw3DRect(n, n3, n2 - 1, n4 - 1, true);
            ++n;
            ++n3;
            n2 -= 2;
            n4 -= 2;
        }

        public Color getColor() {
            return this.color;
        }
    }

    class AxisLayout
    implements LayoutManager {
        Component b1;
        Component b2;
        BackCanvas backCanvas;
        Component bar;
        int barWidth = 4;
        int buttonHeight;
        int buttonWidth;
        int space = 2;

        public void addLayoutComponent(String string, Component component) {
            if (string.equals("B1")) {
                this.b1 = component;
                Dimension dimension = this.b1.getSize();
                this.buttonHeight = dimension.height;
                this.buttonWidth = dimension.width;
                return;
            }
            if (string.equals("B2")) {
                this.b2 = component;
                return;
            }
            if (string.equals("AxisBar")) {
                this.bar = component;
                return;
            }
            if (string.equals("BackCanvas")) {
                this.backCanvas = (BackCanvas)component;
            }
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            if (this.b1 == null) {
                this.bar.setBounds(0, 0, dimension.width, dimension.height);
                return;
            }
            if (dimension.width > dimension.height) {
                int[] nArray = new int[6];
                int[] nArray2 = new int[6];
                nArray[0] = 0;
                nArray2[0] = 0;
                nArray[1] = (this.buttonWidth + this.space) * 2 + this.space;
                nArray2[1] = nArray2[0];
                nArray[2] = nArray[1];
                nArray2[2] = this.buttonHeight + this.space * 2 - (this.barWidth + this.space * 2);
                nArray[3] = dimension.width - 1;
                nArray2[3] = nArray2[2];
                nArray[4] = nArray[3];
                nArray2[4] = this.buttonHeight + this.space * 2;
                nArray[5] = nArray[0];
                nArray2[5] = nArray2[4];
                this.backCanvas.setPoints(nArray, nArray2);
                this.bar.setBounds(this.buttonWidth * 2 + this.space * 3, nArray2[4] - this.space - this.barWidth, dimension.width - (this.buttonWidth * 2 + this.space * 4) - 2, this.barWidth);
                this.b1.setBounds(this.space, this.space, this.buttonWidth, this.buttonHeight);
                this.b2.setBounds(this.buttonWidth + this.space + this.space, this.space, this.buttonWidth, this.buttonHeight);
                return;
            }
            int[] nArray = new int[6];
            int[] nArray3 = new int[6];
            nArray[0] = 0;
            nArray3[0] = 0;
            nArray[1] = this.buttonWidth + this.space * 2;
            nArray3[1] = nArray3[0];
            nArray[2] = nArray[1];
            nArray3[2] = (this.buttonHeight + this.space) * 2 + this.space;
            nArray[3] = this.barWidth + this.space * 2;
            nArray3[3] = nArray3[2];
            nArray[4] = nArray[3];
            nArray3[4] = dimension.height - 1;
            nArray[5] = nArray[0];
            nArray3[5] = nArray3[4];
            this.backCanvas.setPoints(nArray, nArray3);
            this.bar.setBounds(this.space + 1, this.space * 3 + this.buttonHeight * 2, this.barWidth, dimension.height - (this.space * 4 + this.buttonHeight * 2) - 1);
            this.b1.setBounds(this.space + 1, this.space, this.buttonWidth, this.buttonHeight);
            this.b2.setBounds(this.space + 1, this.buttonHeight + this.space + this.space, this.buttonWidth, this.buttonHeight);
        }

        public int getMinimumWidth() {
            int n = this.buttonWidth + this.space * 2 + 1;
            return n;
        }

        public int getMinimumHeight() {
            int n = this.buttonHeight + this.space * 2 + 1;
            return n;
        }

        AxisLayout() {
            AxisCanvas.this = AxisCanvas.this;
        }
    }

    class BackCanvas
    extends Component {
        private Color color;
        int[] xpoints;
        int[] ypoints;
        int length = 6;

        public BackCanvas(Color color) {
            AxisCanvas.this = AxisCanvas.this;
            this.color = color;
        }

        public void setPoints(int[] nArray, int[] nArray2) {
            this.xpoints = nArray;
            this.ypoints = nArray2;
            int n = nArray[0];
            int n2 = nArray[0];
            int n3 = nArray2[0];
            int n4 = nArray2[0];
            int n5 = 1;
            while (n5 < this.length) {
                n = nArray[n5] < n ? nArray[n5] : n;
                n2 = nArray[n5] > n2 ? nArray[n5] : n2;
                n3 = nArray2[n5] < n3 ? nArray2[n5] : n3;
                n4 = nArray2[n5] > n4 ? nArray2[n5] : n4;
                ++n5;
            }
            this.setBounds(n, n3, n2 + 1, n4 + 1);
        }

        public void paint(Graphics graphics) {
            if (this.xpoints == null) {
                return;
            }
            graphics.setColor(this.color);
            graphics.fillPolygon(this.xpoints, this.ypoints, this.length);
            Color color = this.color.brighter();
            Color color2 = this.color.darker();
            int n = 0;
            while (n < this.length) {
                int n2;
                int n3 = n == 0 ? this.xpoints[this.length - 1] : this.xpoints[n - 1];
                int n4 = n2 = n == 0 ? this.ypoints[this.length - 1] : this.ypoints[n - 1];
                if (n3 < this.xpoints[n]) {
                    graphics.setColor(color);
                } else if (n3 > this.xpoints[n]) {
                    graphics.setColor(color2);
                } else if (n2 > this.ypoints[n]) {
                    graphics.setColor(color);
                } else if (n2 < this.ypoints[n]) {
                    graphics.setColor(color2);
                }
                graphics.drawLine(n3, n2, this.xpoints[n], this.ypoints[n]);
                ++n;
            }
        }

        public Color getColor() {
            return this.color;
        }
    }

    class LeftButton
    extends ImgButton {
        Image img;

        public LeftButton(Color color) {
            AxisCanvas.this = AxisCanvas.this;
            int n = color.getRGB();
            int n2 = -16777216;
            int[] nArray = new int[]{n, n, n, n2, n, n, n, n2, n2, n, n, n2, n2, n2, n, n, n, n2, n2, n, n, n, n, n2, n};
            this.img = this.createImage(new MemoryImageSource(5, 5, nArray, 0, 5));
            this.setImage(this.img);
            this.setColor(color);
        }
    }

    class RightButton
    extends ImgButton {
        Image img;

        public RightButton(Color color) {
            AxisCanvas.this = AxisCanvas.this;
            int n = color.getRGB();
            int n2 = -16777216;
            int[] nArray = new int[]{n, n2, n, n, n, n, n2, n2, n, n, n, n2, n2, n2, n, n, n2, n2, n, n, n, n2, n, n, n};
            this.img = this.createImage(new MemoryImageSource(5, 5, nArray, 0, 5));
            this.setImage(this.img);
            this.setColor(color);
        }
    }

    class DownButton
    extends ImgButton {
        Image img;

        public DownButton(Color color) {
            AxisCanvas.this = AxisCanvas.this;
            int n = color.getRGB();
            int n2 = -16777216;
            int[] nArray = new int[]{n, n, n, n, n, n2, n2, n2, n2, n2, n, n2, n2, n2, n, n, n, n2, n, n, n, n, n, n, n};
            this.img = this.createImage(new MemoryImageSource(5, 5, nArray, 0, 5));
            this.setImage(this.img);
            this.setColor(color);
        }
    }

    class UpButton
    extends ImgButton {
        Image img;

        public UpButton(Color color) {
            AxisCanvas.this = AxisCanvas.this;
            int n = color.getRGB();
            int n2 = -16777216;
            int[] nArray = new int[]{n, n, n, n, n, n, n, n2, n, n, n, n2, n2, n2, n, n2, n2, n2, n2, n2, n, n, n, n, n};
            this.img = this.createImage(new MemoryImageSource(5, 5, nArray, 0, 5));
            this.setImage(this.img);
            this.setColor(color);
        }
    }

    class ImgButton
    extends Component {
        Image image;
        String action;
        Vector listeners = new Vector();
        boolean isPressed = false;
        Color color = Color.lightGray;
        int offset = 2;

        public ImgButton() {
            AxisCanvas.this = AxisCanvas.this;
            this.enableEvents(16L);
        }

        public void setImage(Image image) {
            this.image = image;
            int n = image.getHeight(null);
            int n2 = image.getWidth(null);
            this.setSize(n2 + this.offset * 2, n + this.offset * 2);
        }

        public void setActionCommand(String string) {
            this.action = string;
        }

        public void addActionListener(ActionListener actionListener) {
            if (!this.listeners.contains(actionListener)) {
                this.listeners.addElement(actionListener);
            }
        }

        public void removeActionListener(ActionListener actionListener) {
            this.listeners.removeElement(actionListener);
        }

        protected void notifyListeners() {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.action);
            int n = 0;
            while (n < this.listeners.size()) {
                ActionListener actionListener = (ActionListener)this.listeners.elementAt(n);
                actionListener.actionPerformed(actionEvent);
                ++n;
            }
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.color);
            this.color.brighter();
            this.color.darker();
            if (this.isPressed) {
                graphics.fill3DRect(0, 0, dimension.width, dimension.height, false);
            } else {
                graphics.fill3DRect(0, 0, dimension.width, dimension.height, true);
            }
            if (this.image != null) {
                graphics.drawImage(this.image, this.offset, this.offset, null);
            }
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 502: {
                    this.isPressed = false;
                    this.repaint();
                    this.notifyListeners();
                    break;
                }
                case 501: {
                    this.isPressed = true;
                    this.repaint();
                    break;
                }
            }
            super.processMouseEvent(mouseEvent);
        }
    }
}

